﻿using System.Globalization;

// value converts classes help us transform data between source (ViewModel) and the target UI 
// when a direct bounding would be insufficient
namespace MauiSampleViewer.Converters
{
    public class ExpandCollapseIconConverter : IValueConverter
    {
        public object Convert(object? value, Type targetType, object? parameter, CultureInfo culture)
        {
            bool isExpanded = (bool)(value ?? false);
            return isExpanded ? "−" : "+";
        }

        public object ConvertBack(object? value, Type targetType, object? parameter, CultureInfo culture)
            => throw new NotImplementedException();
    }

    public class LevelToIndentConverter : IValueConverter
    {
        public object Convert(object? value, Type targetType, object? parameter, CultureInfo culture)
        {
            int level = (int)(value ?? 0);
            return new Thickness(level * 20, 0, 0, 0);
        }

        public object ConvertBack(object? value, Type targetType, object? parameter, CultureInfo culture)
            => throw new NotImplementedException();
    }

    public class StringEqualityConverter : IValueConverter
    {
        // ViewModel to UI
        public object Convert(object? value, Type targetType, object? parameter, CultureInfo culture)
        {
            if (value is string stringValue && parameter is string paramString)
                return stringValue == paramString;

            return false; 
        }

        // UI to ViewModel
        public object? ConvertBack(object? value, Type targetType, object? parameter, CultureInfo culture)
        {
            if (value is bool isChecked && isChecked && parameter is string targetValue)
                return targetValue;

            return null;
        }
        
    }
}
