﻿namespace MauiSampleViewer;

public partial class OptionsPage : TabbedPage 
{
    public OptionsPage(ViewerOptions options, int defaultTabIndex = 0) 
    {
        InitializeComponent();
        BindingContext = options;
        CurrentPage = Children[defaultTabIndex];    
    }

    // General SCP tab values
    public string LocalAETitle => LocalAETitleEntry.Text;
    public int ListenPort => int.TryParse(ListenPortEntry.Text, out var port) ? port : 104;

    // Storage SCU tab values
    public string StorageRemoteNode => StorageNodeEntry.Text;
    public int StorageRemotePort => int.TryParse(StoragePortEntry.Text, out var port) ? port : 104;
    public string StorageAEName => StorageAEEntry.Text;

    // Query SCU tab values
    public string QueryRemoteNode => QueryRemoteNodeEntry.Text;
    public int QueryRemotePort => int.TryParse(QueryPortEntry.Text, out var port) ? port : 104;
    public string QueryRemoteAE => QueryRemoteAEEntry.Text;
    public string QueryCallingAE => QueryCallingAEEntry.Text;
    public string QueryMoveDestination => QueryMoveDestinationEntry.Text;
    public bool UseCGet => CGetRadio.IsChecked == true;
    public bool UseCMove => CMoveRadio.IsChecked == true;
    public bool UsePatientRoot => PatientRootRadio.IsChecked == true;
    public bool UseStudyRoot => StudyRootRadio.IsChecked == true;

    // Printing tab values
    public string PrinterNodeName => PrinterNodeEntry.Text;
    public int PrinterPort => int.TryParse(PrinterPortEntry.Text, out var port) ? port : 104;
    public string PrinterAEName => PrinterAEEntry.Text;
    public string PrinterClientAEName => PrinterClientAEEntry.Text;
    public bool PrintInColour => PrintInColourSwitch.IsChecked;

    public string SelectedPrintFormat => PrintFormatPicker.SelectedItem?.ToString() ?? "STANDARD\\1.1";
    public string SelectedOrientation => OrientationPicker.SelectedItem?.ToString() ?? "PORTRAIT";
    public string SelectedFilmSize => FilmSizePicker.SelectedItem?.ToString() ?? "8INX10IN";
    public string SelectedMagnification => MagnificationPicker.SelectedItem?.ToString() ?? "NONE";


    // Logging tab values
    public string LogPath => LogPathEntry.Text;
    public string SelectedLogLevel => LogLevelPicker.SelectedItem?.ToString() ?? "Errors & Main Events only (0x7)";
}


