﻿using DicomObjects;
using DicomObjects.Enums;
using SkiaSharp;

namespace MauiSampleViewer;

public partial class LabelForm
{
    private readonly ViewerOptions _options;
    private readonly Window? _window;
    public LabelForm(ViewerOptions options)
    {
        InitializeComponent();
        _options = options;
        BindingContext = options;
    }
    public LabelForm(ViewerOptions options, Window? window)
    {
        InitializeComponent();
        _options = options;
        BindingContext = options;
        _window = window;
    }

    internal LabelType LabelType
    {
        get
        {
            if (IsAngle())
                return LabelType.Line;
            else
                return Enum.TryParse<LabelType>(_options.LabelType, out var type) ? type : LabelType.Text;
        }
    }

    internal ScaleMode ScaleMode
    {
        get
        {
            return Enum.TryParse<ScaleMode>(_options.TiedTo, out var mode) ? mode : ScaleMode.Image;
        }
    }

    internal bool IsAngle()
    {
        return _options.LabelType == "Angle";
    }

    public int LineWidth => int.TryParse(LineWidthEntry.Text, out var width) ? width : 1;

    public SKColor ForeColor => SKColor.TryParse(_options.LabelForeColorHex, out var color) ? color : SKColors.Red;

    public SKColor BackColor => SKColor.TryParse(_options.LabelBackColorHex, out var color) ? color : SKColors.Black;

    public SKFont SelectedFont => new SKFont(SKTypeface.FromFamilyName(FontPicker.SelectedItem?.ToString() ?? "Arial"));
    private void OkClicked(object sender, EventArgs e)
    {
        if (_window != null) Application.Current?.CloseWindow(_window);
    }

    internal DicomLabel NewLabel(SKPoint initialPosition)
    {
        var currentLabel = new DicomLabel()
        {
            ScaleMode = ScaleMode.Output,
            LabelType = LabelType,
            ShowTextBox = false,
            Left = initialPosition.X,
            Top = initialPosition.Y,
            ScaleFontSize = false,
            Paint = new SKPaint { Color = ForeColor, Style = SKPaintStyle.Stroke, StrokeWidth = LineWidth },
            Brush = new SKPaint { Color = ForeColor, Style = SKPaintStyle.Stroke, StrokeWidth = LineWidth },
            Font = SelectedFont
        };

        currentLabel.AddPoint(initialPosition);
        return currentLabel;
    }
}


